/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.network.Packet;
import com.faboslav.friendsandfoes.common.network.base.ClientboundPacketType;
import com.faboslav.friendsandfoes.common.network.base.PacketType;
import com.faboslav.friendsandfoes.common.network.packet.MessageHandler;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public record MoobloomVariantsSyncPacket(List<MoobloomVariant> moobloomVariants) implements Packet<MoobloomVariantsSyncPacket>
{
    public static final class_2960 ID = FriendsAndFoes.makeID("moobloom_variants_sync_packet");
    public static final ClientboundPacketType<MoobloomVariantsSyncPacket> TYPE = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new MoobloomVariantsSyncPacket(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants()), event.player());
    }

    @Override
    public PacketType<MoobloomVariantsSyncPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements ClientboundPacketType<MoobloomVariantsSyncPacket> {
        @Override
        public Class<MoobloomVariantsSyncPacket> type() {
            return MoobloomVariantsSyncPacket.class;
        }

        @Override
        public class_2960 id() {
            return ID;
        }

        @Override
        public Runnable handle(MoobloomVariantsSyncPacket packet) {
            return () -> MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.setMoobloomVariants(packet.moobloomVariants());
        }

        @Override
        public MoobloomVariantsSyncPacket decode(class_9129 buf) {
            ArrayList<MoobloomVariant> parsedMoobloomVariants = new ArrayList<MoobloomVariant>();
            class_2487 data = buf.method_10798();
            if (data == null) {
                FriendsAndFoes.getLogger().error("Moobloom Variant packet is empty");
                return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
            }
            class_2499 moobloomVariants = data.method_10554("moobloom_variants", 10);
            for (class_2520 moobloomVariant : moobloomVariants) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(parsedMoobloomVariants::add);
            }
            return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
        }

        @Override
        public void encode(MoobloomVariantsSyncPacket packet, class_9129 buf) {
            class_2487 data = new class_2487();
            class_2499 parsedMoobloomVariants = new class_2499();
            for (MoobloomVariant moobloomVariant : packet.moobloomVariants()) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to encode Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(arg_0 -> parsedMoobloomVariants.add(arg_0));
            }
            data.method_10566("moobloom_variants", (class_2520)parsedMoobloomVariants);
            buf.method_10794((class_2520)data);
        }
    }
}

